/*
 * cuda_declarations.h
 *
 *  Created on: Oct 22, 2011
 *      Author: michal
 */

#ifndef CUDA_DECLARATIONS_H_
#define CUDA_DECLARATIONS_H_

#include <cuda_runtime.h>
#include <stdio.h>

/*******************************************************************************
 * __CUDACC__ is defined only if we include this file into *.cu file           *
 * and compile it with nvcc                                                    *
 *                                                                             *
 * DO NOT INCLUDE THIS FILE TO *.CPP                                           *
 *******************************************************************************/

	#ifndef __CUDACC__

        //this will be compiled for example in cpp files (although it shouldn't)

        //#include "texture_types.h"

        // define the keywords, so that the IDE does not complain about them
		#ifndef __global__
			#define __global__
			#define __device__
			#define __shared__
			#define __constant__

			struct short2
			{
				short x;
				short y;
			};
			
			struct int3 {
				int x;
				int y;
				int z;
			};
                        
                        struct char2
                        {
                                char x;
                                char y;
                        };
			
          int3 threadIdx, blockIdx, blockDim, gridDim;
			
		#endif
   
    #endif

    #define MAX(a,b) ( ((a)>(b))?(a):(b) )
    #define MIN(a,b) ( ((a)<(b))?(a):(b) )


    //INLINES
    inline void checkError(const char *errorMessage)
    {
        cudaError_t err = cudaGetLastError();
        if(cudaSuccess != err)
        {
            printf("CUDA error: %s [%s]\n", errorMessage, cudaGetErrorString(err));
        }
        err = cudaDeviceSynchronize();
        if(cudaSuccess != err)
        {
            printf("CUDA error: %s [%s]\n", errorMessage, cudaGetErrorString(err));
        }
    }



#endif /* CUDA_DECLARATIONS_H_ */
