%{ 

#include <stdio.h>
#include <string.h>
#include <list>
#include <sstream>

#include "sequence.h"
#include "sequences.h"
#include "exception.h"

using std::list;
using std::stringstream;

using align::Sequence;
using align::Sequences;
using core::Exception;

int fastalex();
int fastaparse();
int fastaerror(const char* msg);

extern int fastaLineNumber;

extern FILE *fastain;
list<Sequence *> *seqs;

typedef list<char *>::iterator lcpi;

%}

%token <_pchar> TK_NAME
%token <_pchar> TK_RESIDUES
%token          TK_WRONG


%type <_ptr> RESIDUES SEQUENCE SEQUENCES

%union
{
   char  _char;
   char *_pchar;
   void *_ptr;
}


%%

S
 : SEQUENCES             { seqs = (list<Sequence *> *)$1; }
 ;

SEQUENCES
 : SEQUENCE              { list<Sequence *> *s = new list<Sequence *>(); s->push_front((Sequence*)$1); $$ = (void*)s; }
 | SEQUENCES SEQUENCE    { list<Sequence *> *s = (list<Sequence *> *)$1; s->push_back((Sequence*)$2); $$ = (void*)s; }
 ;

SEQUENCE
 : TK_NAME RESIDUES      {
                            int sum = 0;
                            list<char *> *l = (list<char *> *)$2;
                            for (lcpi it = l->begin(); it != l->end(); ++it) {
                               sum += strlen(*it);
                            }
                            char *residues = (char*)malloc(sizeof(char) * (sum+1));
                            char *pos = residues;
                            for (lcpi it = l->begin(); it != l->end(); ++it) {
                               for (char *buf = *it; *buf; ++buf, ++pos) {
                                  *pos = *buf;
                               }
                               free(*it);
                            }
                            delete l;
                            *pos = 0;
                            Sequence *s = new Sequence;
                            s->name = $1;
                            s->residues = residues;
                            s->length = sum;
                            $$ = (void*)s;
                         }
 ;

RESIDUES
 : TK_RESIDUES           { list<char *> *l = new list<char *>(); l->push_front($1); $$ = (void*)l; }
 | RESIDUES TK_RESIDUES  { list<char *> *l = (list<char *> *)$1; l->push_back($2); $$ = (void*)l; }
 ;

%%

int fastaerror(const char *msg) {
    stringstream s;
    s << "ERROR: unexpected token in fasta file at " << fastaLineNumber << " line! Message: " << msg;
    
    throw (new Exception())->setMessage(s.str());
}

Sequences::Sequences(string filename) {
    fastaLineNumber = 1;
    fastain = fopen(filename.c_str(), "r");
    if (!fastain)
        throw (new Exception())->setMessage(string("No such file: ") + filename);
    fastaparse();
    this->sequences = seqs;
    this->seqCount = sequences->size();
}

// *::create(string filename) {
//    fastain = fopen(filename.c_str(), "r");
//    fastaparse();
//    return fastaresult;
//}

