/*
 * file_option.cpp
 *
 *  Created on: 2011-09-08
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include "file_option.h"

using std::string;
using std::vector;

using core::FileOption;

vector<string> &FileOption::getCommands(void) {
    vector<string> &result = Option::getCommands();
    if (result.size() == 0) {
        result.push_back("<file>");
    }
    return result;
}

string FileOption::prepareScript(void) {
    return "echo $(compgen -A file ${cur})";
}

string FileOption::getDescription(void) {
    return "path to the file";
}

bool FileOption::acceptUsage(vector<Option *> &optionChain, string cur) {
    this->cur = cur;
    return true;
}
