/*
 * gap_penalty_value_option.cpp
 *
 *  Created on: Oct 22, 2011
 *      Author: michal
 */

#include <stdio.h>
#include <stdlib.h>
#include <sstream>

#include "gap_penalty_value_option.h"

using std::string;
using std::vector;
using std::map;
using std::stringstream;

using core::Option;
using align::GapPenaltyValueOption;

vector<string> &GapPenaltyValueOption::getCommands(void) {
	vector<string> &result = Option::getCommands();
	if (result.size() == 0) {
		for (int i = 1; i < 10; ++i) {
			stringstream value;
			value << i;
			result.push_back(value.str());
		}
	}
	return result;
}

void GapPenaltyValueOption::setParams(map<string, void *> &params) {
	params["gp"] = (void *)value;
}

bool GapPenaltyValueOption::acceptUsage(vector<Option *> &optionChain, string cur) {
	for (int i = 0; i < cur.length(); ++i) {
		if ((cur[i] < '0') || (cur[i] > '9')) {
			return false;
		}
	}
	if (cur.length() == 0) {
		return false;
	}
	value = atoi(cur.c_str());
	return true;
}
