#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <vector>

#include "gpus_value_option.h"

using std::string;
using std::vector;
using std::map;
using std::stringstream;

using core::Option;
using align::GpusValueOption;

vector<string> &GpusValueOption::getCommands(void) {
	vector<string> &result = Option::getCommands();
        result.push_back("0");
        result.push_back("0,1");
        result.push_back("0,1,2");
        result.push_back("0,1,2,3");
        result.push_back("0,1,3");
        result.push_back("0,2");
        result.push_back("0,2,3");
        result.push_back("0,3");
        result.push_back("1");
        result.push_back("1,2");
        result.push_back("1,2,3");
        result.push_back("1,3");
        result.push_back("2");
        result.push_back("2,3");
        result.push_back("3");
        
	return result;
}

void GpusValueOption::setParams(map<string, void *> &params) {
	params["gpus"] = (void *)gpus;
        params["gpusNumber"] = (void *)gpusNumber;
}

bool GpusValueOption::acceptUsage(vector<Option *> &optionChain, string cur) {
	for (int i = 0; i < cur.length(); ++i) {
		if (((cur[i] < '0') || (cur[i] > '9')) && (cur[i] != ',')) {
			return false;
		}
	}
	if (cur.length() == 0) {
		return false;
	}
        int count = 0;
        for (int i = 0; i < cur.length(); ++i) {
            if (cur[i] == ',')
                count++;
        }
        count++;
        gpus = new int[count];
        for (int i = 0; i < count; ++i) {
            gpus[i] = 0;
        }
        int currentInt = 0;
        for (int i = 0; i < cur.length(); ++i) {
            if (cur[i] == ',') {
                currentInt++;
                continue;
            }
            if ((cur[i] >= '0') && (cur[i] <= '9')) {
                gpus[currentInt] *= 10;
                gpus[currentInt] += cur[i] - '0';
            }
        }
        gpusNumber = count;
	return true;
}

