/* 
 * File:   gpus_value_option.h
 * Author: wojtek
 *
 * Created on 2 luty 2012, 22:57
 */

#ifndef GPUS_VALUE_OPTION_H
#define	GPUS_VALUE_OPTION_H

#include <string>
#include <vector>
#include <map>

#include "option.h"

namespace align {
    
    using std::string;
    using std::vector;
    using std::map;

    using core::Option;

    class GpusValueOption : public Option {
    protected:
        int *gpus;
        int gpusNumber;
    public:
        virtual vector<string> &getCommands(void);
        virtual void setParams(map<string, void *> &params);
        virtual bool acceptUsage(vector<Option *> &optionChain, string cur);
    };
    
}

#endif	/* GPUS_VALUE_OPTION_H */

