/*
 * nws_algorithm_option.h
 *
 *  Created on: Oct 15, 2011
 *      Author: michal
 */

#ifndef NWS_ALGORITHM_H_
#define NWS_ALGORITHM_H_

#include <vector>
#include <string>
#include <map>

#include "option.h"
#include "results.h"
#include "sequences.h"
#include "pairs.h"
#include "cuda_declarations.h"
#include "hi_res_timer.h"

namespace align {

    using std::vector;
    using std::string;
    using std::map;

    using core::Option;

    class NWSAlgorithmOption: public Option {
    public:
        virtual vector<string> &getCommands(void);
        virtual void executeOption(map<string, void *> &params);
        virtual void deviceQuery();

        // PARAMETERS
        int gapPenalty;
        int pairsPerGPU;
        
        static int mpi_node_id;
        static int mpi_node_count;
	bool verify;

        //INPUT DATA
        Sequences *seqs;
        SubstitutionMatrix *sm;
        Pairs *p;

        //OUTPUT DATA
        Results *results;
        int fasterKernelInvocationCount;
        int slowerKernelInvocationCount;
        string *resultsFileName;

    private:
        void runAllOnCPU();
        double runAllOnGPU(); // zwraca czas obliczeń
        int2 runSingleNWSOnCPUs(int pairID);
        void compareAllGPUtoCPU();
        bool compareSingleGPUtoCPU(int pairID);

        void initCUDA();
        
        //INPUT DATA
        bool gold;

        int *desiredGpus;
        int desiredGpusNumber;
        int *gpus;

        //HELPERS
        unsigned long long cells;
        int gpuNumber;
#ifndef MPI_ASM_ALIGN
        size_t maxMemory;
#endif
    };

}


#endif /* NWS_ALGORITHM_H_ */
