#include "nws_single_gpu_runnable.h"
#include "nws_single_gpu_runnable_init.h"

using align::NWSSingleGPURunnable;
using align::NWSSingleGPURunnableInit;

void NWSSingleGPURunnable::run() {
    DevPointers devptr = NWSSingleGPURunnableInit::devPtr[this->tm->getThreadsInfo().gpuNo];
    
    int pairsToCompute = MIN(this->nwa->pairsPerGPU, this->nwa->p->pairsCount - this->pairIdToStartWith);
    
    cudaMemcpy(devptr.pair1, &(this->nwa->p->pair1[this->pairIdToStartWith]), pairsToCompute*sizeof(int), cudaMemcpyDefault);
    cudaMemcpy(devptr.pair2, &(this->nwa->p->pair2[this->pairIdToStartWith]), pairsToCompute*sizeof(int), cudaMemcpyDefault);
    cudaMemset(devptr.H, 0, this->memoryOffset * this->nwa->seqs->longestSeq*sizeof(short));
    
    checkError("CUDA COPY ERROR IN NWSSingleGPURunnable!\n");
    
    runOnOneGPU();
    
    cudaMemcpy( &(this->nwa->results->scores_overlaps[this->pairIdToStartWith]), devptr.scores_overlaps, pairsToCompute*sizeof(int2), cudaMemcpyDefault);
    cudaDeviceSynchronize();
}

NWSSingleGPURunnable* NWSSingleGPURunnable::setPairIdToStartWith(unsigned int pairIdToStartWith) {
    this->pairIdToStartWith = pairIdToStartWith;
    return this;
}

NWSSingleGPURunnable *NWSSingleGPURunnable::setMemoryOffset(int memoryOffset) {
    this->memoryOffset = memoryOffset;
    return this;
}
