/*
 * option.cpp
 *
 *  Created on: 2011-09-03
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include <stdio.h>

#include <iostream>

#include "option_not_found_exception.h"
#include "option.h"

using std::vector;
using std::string;

using std::cout;
using std::endl;

using core::OptionNotFoundException;
using core::Option;

typedef vector<string>::iterator vsit;
typedef vector<Option *>::iterator vopit;

Option::Option(void) :
    commands(NULL), suboptions(NULL) {

}

bool Option::containsCommand(string command) {
    for (vsit it = getCommands().begin(); it != getCommands().end(); it++) {
        if (*it == command) {
            return true;
        }
    }
    return false;
}

string Option::prepareScript(void) {
    string buffer("echo $(compgen -W \"");
    for (vsit it = getCommands().begin(); it != getCommands().end(); it++) {
        buffer += (*it) + " ";
    }
    return buffer + "\" -- ${cur})";
}

bool Option::optionAlreadyInChain(vector<Option *> &optionChain) {
    for (vopit it = optionChain.begin(); it != optionChain.end(); it++) {
        if (*it == this) {
            return true;
        }
    }
    return false;
}

vector<Option *> &Option::getSuboptions(void) {
    if (suboptions == NULL) {
        suboptions = new vector<Option *> ();
    }
    return *suboptions;
}

Option &Option::addSuboption(Option *suboption) {
    this->getSuboptions().push_back(suboption);
    return *this;
}

Option &Option::addSuboptionGroup(vector<Option *> &suboptions) {
    for (vopit it = suboptions.begin(); it != suboptions.end(); it++) {
        addSuboption(*it);
    }
    return *this;
}

void Option::setParams(map<string, void *> &params) {

}

void Option::executeOption(map<string, void *> &params) {

}

vector<Option *> *Option::getOptionChain(vector<Option *> *optionChain,
        int cur, int argc, const char *argv[]) {
    if (optionChain == NULL) {
        optionChain = new vector<Option *> ();
    }
    if (argc == cur) {
        return optionChain;
    }

    for (vopit it = getSuboptions().begin(); it != getSuboptions().end(); it++) {
        if ((*it)->acceptUsage(*optionChain, argv[cur])) {
            optionChain->push_back(*it);
            (*it)->getOptionChain(optionChain, cur + 1, argc, argv);
            return optionChain;
        }
    }

    throw(new OptionNotFoundException())->setMessage(string("Option \"")
            + argv[cur] + "\" hasn't been found.");
}

bool Option::acceptUsage(vector<Option *> &optionChain, string cur) {
    return containsCommand(cur) && !optionAlreadyInChain(optionChain);
}

vector<string> &Option::getCommands(void) {
    if (commands == NULL) {
        commands = new vector<string> ();
    }
    return *commands;
}

bool Option::isHidden(void) {
    return false;
}

string Option::getDescription() {
	return "";
}


