/*
 * option_manager.cpp
 *
 *  Created on: 2011-09-06
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include "option_manager.h"


using std::string;
using std::vector;
using std::map;

using core::OptionManager;
using core::HelpOption;
using core::Option;
using core::CompleteOption;

using align::SubstitutionMatrixOption;
using align::SubstitutionMatrixFileOption;

using test::TestSubstitutionMatrixOption;

typedef vector<Option *>::iterator vopit;

OptionManager::OptionManager(void)
    : optionChain(NULL), root(NULL), help(NULL), params() {
    initOptions();
}

void OptionManager::initOptions(void) {
    root = new RootOption;
    help = new HelpOption;
    sm = new SubstitutionMatrixOption;
    smf = new SubstitutionMatrixFileOption;
    co = new CompleteOption;
    tsmo = new TestSubstitutionMatrixOption;
    fo = new FastaOption;
    ffo = new FastaFileOption;
    ao = new AlgorithmOption;
    na = new NWSAlgorithmOption;
    po = new PairsOption;
    pfo = new PairsFileOption;
    go = new GoldOption;
    gpo = new GapPenaltyOption;
    gpvo = new GapPenaltyValueOption;
    gpuo = new GpusOption;
    gpuvo = new GpusValueOption;
    ppgo = new PairsPerGpuOption;
    ppgvo = new PairsPerGpuValueOption;
    vro = new VerifyResultsOption;
    ro = new ResultsOption;
    rfo = new ResultsFileOption;

    root->addSuboption(help);
    root->addSuboption(sm);
    root->addSuboption(co);
    root->addSuboption(tsmo);
    root->addSuboption(fo);
    root->addSuboption(ao);
    root->addSuboption(po);
    root->addSuboption(go);
    root->addSuboption(gpo);
    root->addSuboption(gpuo);
    root->addSuboption(ppgo);
    root->addSuboption(vro);
    root->addSuboption(ro);

    sm->addSuboption(smf); // after "-sm" one can type only a filename
    fo->addSuboption(ffo);
    ao->addSuboption(na);
    po->addSuboption(pfo);
    gpo->addSuboption(gpvo);
    gpuo->addSuboption(gpuvo);
    ppgo->addSuboption(ppgvo);
    ro->addSuboption(rfo);
    

    smf->addSuboptionGroup(root->getSuboptions()); // all options are available after "smf" option
    co->addSuboptionGroup(root->getSuboptions());
    tsmo->addSuboptionGroup(root->getSuboptions());
    ffo->addSuboptionGroup(root->getSuboptions());
    na->addSuboptionGroup(root->getSuboptions());
    pfo->addSuboptionGroup(root->getSuboptions());
    go->addSuboptionGroup(root->getSuboptions());
    gpvo->addSuboptionGroup(root->getSuboptions());
    gpuvo->addSuboptionGroup(root->getSuboptions());
    ppgvo->addSuboptionGroup(root->getSuboptions());
    vro->addSuboptionGroup(root->getSuboptions());
    rfo->addSuboptionGroup(root->getSuboptions());
    
    help->setRootOption(root);
}

void OptionManager::bindOptions(int argc, const char* argv[]) {
    if (optionChain == NULL) {
        optionChain = new vector<Option *>();
    } else {
        optionChain->clear();
    }

    optionChain = root->getOptionChain(NULL, 1, argc, argv);

    for (vopit it = optionChain->begin(); it != optionChain->end(); it++) {
        (*it)->setParams(params);
    }
}

void OptionManager::executeActions(void) {
    for (vopit it = optionChain->begin(); it != optionChain->end(); it++) {
        (*it)->executeOption(params);
    }
}

map<string, void *> &OptionManager::getParams(void) {
    return params;
}
