/*
 * option_manager.h
 *
 *  Created on: 2011-09-05
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#ifndef OPTION_MANAGER_H_
#define OPTION_MANAGER_H_

#include <map>

#include "root_option.h"
#include "help_option.h"
#include "substitution_matrix_option.h"
#include "substitution_matrix_file_option.h"
#include "complete_option.h"
#include "test_substitution_matrix_option.h"
#include "fasta_option.h"
#include "fasta_file_option.h"
#include "algorithm_option.h"
#include "nws_algorithm_option.h"
#include "pairs_option.h"
#include "pairs_file_option.h"
#include "gold_option.h"
#include "gap_penalty_option.h"
#include "gap_penalty_value_option.h"
#include "gpus_option.h"
#include "gpus_value_option.h"
#include "pairs_per_gpu_option.h"
#include "pairs_per_gpu_value_option.h"
#include "verify_results_option.h"
#include "results_option.h"
#include "results_file_option.h"

namespace core {

    using std::map;

    using align::SubstitutionMatrixOption;
    using align::SubstitutionMatrixFileOption;
    using align::FastaOption;
    using align::FastaFileOption;
    using align::AlgorithmOption;
    using align::NWSAlgorithmOption;
    using align::PairsOption;
    using align::PairsFileOption;
    using align::GoldOption;
    using align::GapPenaltyOption;
    using align::GapPenaltyValueOption;
    using align::GpusOption;
    using align::GpusValueOption;
    using align::PairsPerGpuOption;
    using align::PairsPerGpuValueOption;
    using align::VerifyResultsOption;
    using align::ResultsOption;
    using align::ResultsFileOption;


    using test::TestSubstitutionMatrixOption;

    class OptionManager {
    protected:
        RootOption *root;
        HelpOption *help;
        SubstitutionMatrixOption *sm;
        SubstitutionMatrixFileOption *smf;
        CompleteOption *co;
        TestSubstitutionMatrixOption *tsmo;
        FastaOption *fo;
        FastaFileOption *ffo;
        AlgorithmOption *ao;
        NWSAlgorithmOption *na;
        PairsOption *po;
        PairsFileOption *pfo;
        GoldOption *go;
        GapPenaltyOption *gpo;
        GapPenaltyValueOption *gpvo;
        GpusOption *gpuo;
        GpusValueOption *gpuvo;
        PairsPerGpuOption *ppgo;
        PairsPerGpuValueOption *ppgvo;
        VerifyResultsOption *vro;
        ResultsOption *ro;
        ResultsFileOption *rfo;

        vector<Option *> *optionChain;
        map<string, void *> params;
    public:
        OptionManager(void);
        virtual void initOptions(void);
        virtual void bindOptions(int argc, const char* argv[]);
        virtual void executeActions(void);
        virtual map<string, void *> &getParams(void);
    };

}

#endif /* OPTION_MANAGER_H_ */
