#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <vector>

#include "pairs_per_gpu_value_option.h"

using std::string;
using std::vector;
using std::map;
using std::stringstream;

using core::Option;
using align::PairsPerGpuValueOption;

vector<string> &PairsPerGpuValueOption::getCommands(void) {
	vector<string> &result = Option::getCommands();
        result.push_back("16384");
        
	return result;
}

void PairsPerGpuValueOption::setParams(map<string, void *> &params) {
	params["pairsPerGpu"] = (void *)pairsPerGpu;
}

bool PairsPerGpuValueOption::acceptUsage(vector<Option *> &optionChain, string cur) {
	for (int i = 0; i < cur.length(); ++i) {
		if ((cur[i] < '0') || (cur[i] > '9')) {
			return false;
		}
	}
	if (cur.length() == 0) {
		return false;
	}
        pairsPerGpu = atoi(cur.c_str());
        
	return true;
}


