#include <stdio.h>

#include "results.h"

using std::string;

using align::Results;

Results::Results(int pairsCount) {
    scores_overlaps = new int2[pairsCount];
}

Results::~Results() {
    delete[] scores_overlaps;
}

void Results::save(string &fileName, Pairs *p, int pairsPerGPU, int mpi_node_count, int mpi_node_id) {
    FILE *fd = fopen(fileName.c_str(), "a");
    
    for (unsigned int i = pairsPerGPU * mpi_node_id;
                i < p->pairsCount;
                i += pairsPerGPU * mpi_node_count)
        {
            for (unsigned int j=i; (j<i+pairsPerGPU) && (j < p->pairsCount); j++)
                fprintf(fd, "%u %u %d %d\n", p->pair1[j], p->pair2[j], scores_overlaps[j].x, scores_overlaps[j].y);
        }
    
    fclose(fd);
}

