/*
 * sequences.h
 *
 *  Created on: Oct 8, 2011
 *      Author: michal
 */

#ifndef SEQUENCES_H_
#define SEQUENCES_H_

#include <string>
#include <list>

#include "sequence.h"
#include "substitution_matrix.h"

/*
 * 3 podejscia do sprawdzenia dlugosci sekwencji:
 * - tablica lengths
 * - dodatkowy symbl konca sekwencji (taki jak A, C, G, T)
 * - zalozyc ze kazda sekwencja ma taka sama dlugosc
 */


namespace align {

    using std::string;
	using std::list;

	class Sequences {
	protected:

		void packSequence(unsigned int *memory, Sequence *seqToPack);
		char* unpackSequence(int seqNo);
	public:
                Sequences();
		Sequences(string filename);
		Sequences(list<Sequence *> *sequences); // for Gawi
		~Sequences();

		void packSequences(SubstitutionMatrix *sm); // should be called by the algorithm (when all parameters are loaded)
		bool testPacking();
                void bcast(SubstitutionMatrix *sm);
		

        SubstitutionMatrix *sm;
		list<Sequence *> *sequences;
		unsigned int *packedSeqs; // array with packed sequences
		size_t  packedSeqsSize; // memory used by packed sequences (in bytes)
		int bits; // the number of bits needed to store a single residue
		int mask; // the mask for the unpacking purposes
		int residuesPer32bit;
		int *starts;     // e.g. starts[3] -> index in the array "packedSeqs" where 3rd sequence starts
		int *lengths;    // length of sequences (number of residues)
		int longestSeq;  // length of the longest sequences (in residues)
                int seqCount; // number of sequences (used ONLY to transfer to MPI hosts)
                
	};

}


#endif /* SEQUENCES_H_ */
