/*
 * substitution_matrix.cpp
 *
 *  Created on: 2011-09-13
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include <limits.h>

#include <iostream>
#include <list>

#include "substitution_matrix.h"

#define INDEX(x, y)     ((y)*((y) + 1)/2 + (x))
#define MIN(x, y)       (((x) > (y))?(y):(x))
#define MAX(x, y)       (((x) < (y))?(y):(x))

using align::SubstitutionMatrix;

using namespace std;

typedef list<char>::iterator lcit;

SubstitutionMatrix::SubstitutionMatrix(list<char> *residues, int *matrix) {
	this->residues = residues;
	this->substitutionMatrix = matrix;
	this->residuesCount = this->residues->size();
	this->convResidueToIdx = new unsigned int[256];
	this->convResidueToIdx += 128;
	for (int c = -128; c <= 127; ++c) {
		this->convResidueToIdx[c] = -1;
	}
	for (int i = 0; i < 32; ++i) {
		this->convIdxToResidue[i] = 0;
	}
	lcit it;
	unsigned int counter;
	for (it = residues->begin(), counter = 0; it != residues->end(); ++it, ++counter) {
		convResidueToIdx[*it] = counter;
		convIdxToResidue[counter] = *it;
	}


//	for (int i = 0; i < 32; ++i) {
//		cout << i << " " << this->convIdxToResidue[i] << endl;
//	}
//	cout << endl;
//	for (char c = 'A'; c <= 'Z'; ++c) {
//		cout << c << " " << this->convResidueToIdx[c] << endl;
//	}
//	cout << '*' << " " << this->convResidueToIdx['*'] << endl;
//	cout << endl;
}


void SubstitutionMatrix::pack(void) {
	this->max_value = INT_MIN;
	this->min_value = INT_MAX;
	for (int j = 0; j < this->residuesCount; ++j) {
		for (int i = 0; i <= j; ++i) {
			if (this->substitutionMatrix[i + j * this->residuesCount] > max_value) {
				max_value = this->substitutionMatrix[i + j * this->residuesCount];
			}
			if (this->substitutionMatrix[i + j * this->residuesCount] < min_value) {
				min_value = this->substitutionMatrix[i + j * this->residuesCount];
			}
		}
	}
	int delta = max_value - min_value;
	this->bits = 1;
	for (int i = 0; i < 8; ++i) {
		if (delta & (1 << i)) {
			this->bits = i + 1;
		}
	}
	this->mask = 0;
	for (int i = 0; i < this->bits; ++i) {
		this->mask |= (1 << i);
	}
	this->valuesPerInt = (sizeof(int) * 8) / this->bits;

	this->packedSize = (this->residuesCount + 1) * this->residuesCount / (2 * this->valuesPerInt);
	this->packedSize++;
	this->packedMatrix = new int[this->packedSize];

	for (int j = 0; j < this->residuesCount; ++j) {
		for (int i = 0; i <= j; ++i) {
			int wordNo = INDEX(i, j) / this->valuesPerInt;
			int offset = INDEX(i, j) % this->valuesPerInt;
			if (offset == 0) {
				this->packedMatrix[wordNo] = 0;
			}
			this->packedMatrix[wordNo] |= ((this->substitutionMatrix[i + j * this->residuesCount]
					- this->min_value) << (offset * this->bits));
		}
	}
}

int SubstitutionMatrix::getPacked(int x, int y) {
	int i, j;
	i = MIN(x, y);
	j = MAX(x, y);
	int wordNo = INDEX(i, j) / this->valuesPerInt;
	int offset = INDEX(i, j) % this->valuesPerInt;
	return ((this->packedMatrix[wordNo] >> (offset * this->bits)) & this->mask)
			+ this->min_value;
}

int SubstitutionMatrix::getNotPacked(int x, int y) {
	return substitutionMatrix[x + y * this->residuesCount];
}

int SubstitutionMatrix::getResiduesCount(void) {
	return this->residuesCount;
}
