/*
 * test_substitution_matrix_option.cpp
 *
 *  Created on: 2011-09-19
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include <iostream>
#include <string>
#include <vector>
#include <map>

#include "option.h"
#include "test_substitution_matrix_option.h"
#include "substitution_matrix.h"

using std::cout;
using std::endl;
using std::string;
using std::vector;
using std::map;

using core::Option;
using test::TestSubstitutionMatrixOption;
using align::SubstitutionMatrix;

vector<string> &TestSubstitutionMatrixOption::getCommands(void) {
    vector<string> &result = Option::getCommands();
    if (result.size() == 0) {
        result.push_back("--test-subm");
    }
    return result;
}

string TestSubstitutionMatrixOption::getDescription(void) {
    return "tests the substitution matrix";
}

void TestSubstitutionMatrixOption::executeOption(map<string, void *> &params) {
    SubstitutionMatrix *sm = (SubstitutionMatrix *) params["sm"];
    cout << "Testing substitution matrix... ";
    bool OK = true;
    for (int j = 0; j < sm->getResiduesCount(); ++j) {
        for (int i = 0; i < sm->getResiduesCount(); ++i) {
            if (sm->getPacked(i, j) != sm->getNotPacked(i, j)) {
                OK = false;
            }
        }
    }
    if (OK) {
        cout << "OK" << endl;
    } else {
        cout << "Failed!" << endl;
    }
}

