/*
 * complete_option.cpp
 *
 *  Created on: 2011-09-09
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include <iostream>
#include <stdlib.h>

#include "complete_option.h"

using std::string;
using std::vector;
using std::cout;
using std::endl;

using core::Option;
using core::CompleteOption;

typedef vector<Option *>::iterator vopit;

vector<Option *> *CompleteOption::getOptionChain(vector<Option *> *optionChain,
        int cur, int argc, const char *argv[]) {
    this->argc = argc;
    this->argv = argv;
    if (optionChain == NULL) {
        optionChain = new vector<Option *> ();
    }
    return optionChain;
}

vector<string> &CompleteOption::getCommands(void) {
    vector<string> &result = Option::getCommands();
    if (result.size() == 0) {
        result.push_back("--complete");
    }
    return result;
}

string CompleteOption::getDescription(void) {
    return "tries to complete given option chain";
}

bool CompleteOption::acceptUsage(vector<Option *> &optionChain, string cur) {
    return containsCommand(cur) && (optionChain.size() == 0);
}

void CompleteOption::executeOption(map<string, void *> &params) {
    vector<Option *> optionChain;
    int cur = 3;
    Option *option = this;
    Option *newOption = this;

    int count = atoi(argv[2]);

    while (cur < count + 2) {
        for (vopit it = option->getSuboptions().begin(); it
                != option->getSuboptions().end(); ++it) {
            if ((*it)->acceptUsage(optionChain, argv[cur])) {
                optionChain.push_back(*it);
                newOption = *it;
                break;
            }
        }
        if (option == newOption) {
            cout << endl;
            return;
        }
        cur++;
        option = newOption;
    }
    for (vopit it = option->getSuboptions().begin(); it
            != option->getSuboptions().end(); ++it) {
        cout << (*it)->prepareScript() << endl;
    }
}
