/*
 * help_option.cpp
 *
 *  Created on: 2011-09-04
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <algorithm>
#include <stack>
#include <map>

#include "help_option.h"

using std::vector;
using std::string;
using std::stack;
using std::map;
using std::sort;
using core::Option;
using core::HelpOption;

typedef vector<string>::iterator vsit;
typedef vector<Option *>::iterator vopit;

string exec(const char* cmd) {
    FILE* pipe = popen(cmd, "r");
    if (!pipe)
        return "ERROR";
    char buffer[128];
    string result = "";
    while (!feof(pipe)) {
        if (fgets(buffer, 128, pipe) != NULL)
            result += buffer;
    }
    pclose(pipe);
    return result;
}

void HelpOption::setRootOption(RootOption *root) {
    this->root = root;
}

vector<string> &HelpOption::getCommands(void) {
    if (commands == NULL) {
        commands = new vector<string> ();
        commands->push_back("--help");
        commands->push_back("-h");
    }
    return *commands;
}

string HelpOption::getDescription(void) {
    return "displays this information";
}

bool optionComparator(Option *op1, Option *op2) {
    return op1->getCommands()[0] < op2->getCommands()[0];
}

void HelpOption::executeOption(map<string, void *> &params) {
    vector<Option *> allOptions;
    allOptions = root->getSuboptions();
    sort(allOptions.begin(), allOptions.end(), optionComparator);
    for (vopit it = allOptions.begin(); it != allOptions.end(); it++) {
        if (!(*it)->isHidden()) {
            for (vsit it2 = (*it)->getCommands().begin(); it2
                    != (*it)->getCommands().end(); it2++) {
                printf("%s ", it2->c_str());
            }
            printf("-- %s\n", (*it)->getDescription().c_str());
        }
    }
}

