/*
 * main.cpp
 *
 *  Created on: 2011-09-02
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */
#include <iostream>

#include "option_manager.h"
#include "exception.h"
#include "nws_algorithm_option.h"


#ifdef MPI_ASM_ALIGN
#include <mpi.h>
#endif /* MPI_ASM_ALIGN */

using namespace std;

using core::OptionManager;
using core::Exception;
using align::NWSAlgorithmOption;

int main(int argc, char* argv[]) {
    
    NWSAlgorithmOption::mpi_node_id = 0;
    NWSAlgorithmOption::mpi_node_count = 1;
#ifdef MPI_ASM_ALIGN
    MPI_Init(&argc,&argv);
    MPI_Comm_size(MPI_COMM_WORLD, &NWSAlgorithmOption::mpi_node_count);
    MPI_Comm_rank(MPI_COMM_WORLD, &NWSAlgorithmOption::mpi_node_id);
#endif /* MPI_ASM_ALIGN */
    
    try {
        OptionManager om;
        om.bindOptions(argc, (const char**)argv);
//#ifdef MPI_ASM_ALIGN
//        om.getParams()["mpi_node_id"] = (void *)mpi_node_id;
//        om.getParams()["mpi_node_count"] = (void *)mpi_node_count;
//#endif /* MPI_ASM_ALIGN */
        om.executeActions();

    } catch (Exception *ex) {
        cout << ex->getMessage() << endl;
    }

#ifdef MPI_ASM_ALIGN
    MPI_Finalize();
#endif /* MPI_ASM_ALIGN */
    
    return 0;
}
