#include "nws_single_gpu_runnable_finalization.h"
#include "nws_single_gpu_runnable_init.h"
#include "thread_manager_runnable.h"
#include "dev_pointers.h"

using align::NWSSingleGPURunnableInit;
using align::NWSSingleGPURunnableFinalization;
using align::DevPointers;

void NWSSingleGPURunnableFinalization::run() {
    DevPointers devptr = NWSSingleGPURunnableInit::devPtr[this->tm->getThreadsInfo().gpuNo];
    
    cudaFree(devptr.packedSeqs);
    cudaFree(devptr.starts);
    cudaFree(devptr.lengths);
    cudaFree(devptr.pair1);
    cudaFree(devptr.pair2);
    cudaFree(devptr.scores_overlaps);
    cudaFree(devptr.H);
    cudaFree(devptr.sm);
}
