/*
 * option.h
 *
 *  Created on: 2011-09-02
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#ifndef OPTION_H_
#define OPTION_H_

#include <string>
#include <vector>
#include <map>

namespace core {

    using std::string;
    using std::vector;
    using std::map;

    class Option {
    protected:
        vector<Option *> *suboptions;
        vector<string> *commands;

        virtual bool optionAlreadyInChain(vector<Option *> &optionChain);
    public:
        Option(void);
        virtual vector<string> &getCommands(void);
        virtual string getDescription(void);

        virtual bool containsCommand(string current);
        virtual bool acceptUsage(vector<Option *> &optionChain, string cur);
        virtual void setParams(map<string, void *> &params);
        virtual void executeOption(map<string, void *> &params);
        virtual string prepareScript(void);
        virtual vector<Option *> &getSuboptions(void);
        virtual Option &addSuboption(Option *suboption);
        virtual Option &addSuboptionGroup(vector<Option *> &suboptions);
        virtual vector<Option *> *getOptionChain(vector<Option *> *optionChain,
                int cur, int argc, const char *argv[]);
        virtual bool isHidden(void);
    };

}

#endif /* OPTION_H_ */
