%{ 

#include <stdio.h>
#include <string.h>
#include <list>

#include "pairs.h"
#include "exception.h"

using std::list;

using align::Pairs;
using core::Exception;

int pairslex();
int pairsparse();
int pairserror(const char* msg);

extern FILE *pairsin;
unsigned int count;
unsigned int *pair1;
unsigned int *pair2;

%}

%token <_uint>   TK_NUM
%token          TK_WRONG

%type <_uint> PAIRS

%union
{
   int  _int;
   unsigned int _uint;
   void *_ptr;
}


%%

S
 : TK_NUM { count = $1; pair1 = new unsigned int[count]; pair2 = new unsigned int[count]; } PAIRS                
 ;

PAIRS
 : TK_NUM TK_NUM        { unsigned int i = 0;  pair1[i] = $1; pair2[i] = $2; $$ = i; }         
 | PAIRS TK_NUM TK_NUM { unsigned int i = $1 + 1; pair1[i] = $2; pair2[i] = $3; $$ = i; }
 ;


%%

int pairserror(const char *msg) {
    throw (new Exception())->setMessage("ERROR: unexpected token in pairs file!");
}

Pairs::Pairs(string filename) : pair1(NULL), pair2(NULL) {
    pairsin = fopen(filename.c_str(), "r");
    if (!pairsin)
        throw (new Exception())->setMessage(string("No such file: ") + filename);
    pairsparse();
    this->pair1 = ::pair1;
    this->pair2 = ::pair2; 
    this->pairsCount = count;
}

Pairs::~Pairs() {
    if (this->pair1)
        delete[] this->pair1;
    if (this->pair2)
        delete[] this->pair2;
}
