/*
 * pairs_file_option.cpp
 *
 *  Created on: Oct 15, 2011
 *      Author: michal
 */

#include "pairs.h"
#include "pairs_file_option.h"
#include "nws_algorithm_option.h"

using std::map;
using std::string;

using align::Pairs;
using align::PairsFileOption;
using align::NWSAlgorithmOption;

void PairsFileOption::setParams(map<string, void *> &params) {
    Pairs *pairs = NULL;
    if(NWSAlgorithmOption::mpi_node_id == 0)
    {
	pairs = new Pairs(this->cur, 512);
    }
    else
    {
        #ifdef MPI_ASM_ALIGN
            pairs = new Pairs();
        #endif /* MPI_ASM_ALIGN */
    }

    params["pairs"] = pairs;
}
