#include "pairs_per_gpu_option.h"

using std::string;
using std::vector;
using std::map;

using align::PairsPerGpuOption;

vector<string> &PairsPerGpuOption::getCommands(void) {
    vector<string> &result = Option::getCommands();
    if (result.size() == 0) {
        result.push_back("--pairs-per-gpu");
        result.push_back("-ppg");
    }
    return result;
}

string PairsPerGpuOption::getDescription(void) {
	return "maximum number of pairs aligned on a single GPU at once";
}

