%{ 

#include <stdio.h>
#include <list>

#include "substitution_matrix_file_format_exception.h"
#include "substitution_matrix.h"

using std::list;

using align::SubstitutionMatrixFileFormatException;
using align::SubstitutionMatrix;

int smlex();
int smparse();
int smerror(const char* msg);

extern FILE *smin;

SubstitutionMatrix *smresult;

struct ResidueWithValues{
    char residue;
    list<int> *values;
};

%}

%token         TK_WRONG
%token         TK_NEW_LINE
%token <_char> TK_RESIDUE
%token <_int>  TK_VALUE

%type <_ptr> TITLE_LINE VALUE_LINES VALUE_LINE VALUES

%union
{
   char  _char;
   int   _int;
   void* _ptr;
}


%%

S
 : MATRIX
 ;

MATRIX
 : EMPTY_LINES MATRIX_LINES
 ;

EMPTY_LINES
 : TK_NEW_LINE EMPTY_LINES
 | 
 ;
 
MATRIX_LINES
 : TITLE_LINE VALUE_LINES {
                             list<char> *residues = (list<char> *)$1;
                             list<ResidueWithValues *> *rsWV = (list<ResidueWithValues *> *)$2;
                             if (residues->size() != rsWV->size()) {
                                throw (new SubstitutionMatrixFileFormatException())->setMessage("The number of substitution matrix columns doesn't correspond to the number of rows");
                                //return 1;
                             }
                             int *tab = new int[rsWV->size()*rsWV->size()];
                             int i, j;
                             list<char>::iterator resIt;
                             list<ResidueWithValues *>::iterator rwvIt;
                             list<int>::iterator valIt;
                             for (rwvIt = rsWV->begin(), j = 0; rwvIt != rsWV->end(); ++rwvIt, ++j) {
                                for (resIt = residues->begin(), valIt = (*rwvIt)->values->begin(), i = 0;
                                     (resIt != residues->end()) && (valIt != (*rwvIt)->values->end());
                                     ++resIt, ++valIt, ++i) {
                                   tab[i + j*rsWV->size()] = *valIt;
                                }
                             }
                             for (j = 0; j < rsWV->size(); ++j) {
                                for (i = 0; i <= j; ++i) {
                                   if (tab[i + j*rsWV->size()] != tab[j + i*rsWV->size()]) {
                                      throw (new SubstitutionMatrixFileFormatException())->setMessage("The substitution matrix isn't symmetric");
                                   }
                                }
                             }
                             smresult = new SubstitutionMatrix(residues, tab);
                             smresult->pack();
                             
                          }
 ;

TITLE_LINE
 : TK_RESIDUE TITLE_LINE  { list<char> *residues = (list<char> *)$2; residues->push_front($1); $$ = (void *)residues; }
 | TK_RESIDUE TK_NEW_LINE { list<char> *residues = new list<char>(); residues->push_front($1); $$ = (void *)residues; }
 ;

VALUE_LINES
 : VALUE_LINE VALUE_LINES { list<ResidueWithValues *> *rsWV = (list<ResidueWithValues *> *)$2; rsWV->push_front((ResidueWithValues *)$1); $$ = (void *)rsWV; }
 | VALUE_LINE             { list<ResidueWithValues *> *rsWV = new list<ResidueWithValues *>(); rsWV->push_front((ResidueWithValues *)$1); $$ = (void *)rsWV; }
 ;

VALUE_LINE
 : TK_RESIDUE VALUES TK_NEW_LINE { ResidueWithValues *rWV = new ResidueWithValues(); rWV->residue = $1; rWV->values = (list<int> *)$2; $$ = (void *) rWV; }
 ;

VALUES
 : TK_VALUE VALUES        { list<int> *values = (list<int> *)$2; values->push_front($1); $$ = (void *)values;}
 | TK_VALUE               { list<int> *values = new list<int>(); values->push_front($1); $$ = (void *)values;}
 ;

%%

int smerror(const char* msg) {
    return 1;
}

SubstitutionMatrix *SubstitutionMatrix::create(string filename) {
    smin = fopen(filename.c_str(), "r");
    if (!smin)
        throw (new Exception())->setMessage(string("No such file: ") + filename);
    smparse();
    return smresult;
}

