/*
 * substitution_matrix.h
 *
 *  Created on: 2011-09-13
 *      Author: Wojciech Frohmberg
 *              Michal Kierzynka
 */

#ifndef SUBSTITUTION_MATRIX_H_
#define SUBSTITUTION_MATRIX_H_

#include <string>
#include <list>

namespace align {

    using std::string;
    using std::list;

    class SubstitutionMatrix {
    protected:
        int *packedMatrix; // not used
        int packedSize;
        int bits;
        int mask;
        int valuesPerInt;
        int min_value;
        int max_value;

        list<char> *residues;

    public:
        static SubstitutionMatrix *create(string filename);
        SubstitutionMatrix(list<char> *residues, int *matrix);

        int getResiduesCount(void);
        void pack(void);
        int getPacked(int x, int y);
        int getNotPacked(int x, int y);
        
        unsigned int *convResidueToIdx;     // e.g. convResidueToIdx['A'] ->  0
        char convIdxToResidue[32]; // e.g. convIdxToResidue[ 0 ] -> 'A'
        
        int *substitutionMatrix; // sm that we use
        int residuesCount;
    };

}

#endif /* SUBSTITUTION_MATRIX_H_ */
