#ifndef _ARGUMENTS_MANAGER_H_
#define _ARGUMENTS_MANAGER_H_

using std::map;
using std::string;
using std::list;

class ArgumentsManager
{
protected:

    static list<string> unpresentFiles;

    map<string, string> stringValues;
    map<string, int>    intValues;
    map<string, double> doubleValues;

    map<string, int>    loadingTimes;

    int ticks;

    virtual void castValues();

    static bool strStartsWith(string s, const char* beggining);
    static string trim(string s);
    static string** split(string s, char c);
    static void splitFree(string** spl);

    int argc;
    char** argv;



public:

    virtual void openConfig(const char* filename);
    virtual void reloadArgs();
    ArgumentsManager(int argc, char** argv);

    const char* getParam(const char* shortName, const char* longName);

    void addParam(string name, string value);

    string getStringParam(string longName, string shortName = "");
    int    getIntParam   (string longName, string shortName = "");
    double getDoubleParam(string longName, string shortName = "");
    bool   getBoolParam  (string longName, string shortName = "");

    bool containParam(string longName, string shortName = "");

};

#endif
