#include "extended_library.h"

ExtendedLibrary::ExtendedLibrary()
{
    el = NULL;
}

ExtendedLibrary::~ExtendedLibrary()
{
    if(el)
        delete[] el;
}

void ExtendedLibrary::allocateEL()
{
    if(el)
    {
        delete[] el;
        el = NULL;
    }
    
    if(totalNumOfElements == 0)
        throw new IndexOutOfRangeException("An attempt to create empty extended library.\n");
    
    try
    {
        el = new unsigned int[totalNumOfElements];
        printf("Allocation of %.0fMB memory for EL.\n", ((double)(totalNumOfElements*4))/(1024.0*1024.0));
    }
    catch(...)
    {
        printf("Allocation of %.0fMB memory for EL failed.\n", ((double)(totalNumOfElements*4))/(1024.0*1024.0));
        throw new IndexOutOfRangeException("Not enough memory for extended library! Terminating.");
    }
}
