%{
#include <stdio.h>
#include <iostream>
#include <typeinfo>

//należy dodać w przypadku kompilowania gramatyki YACCowej
#include "phylip-gram.hh"
#include "nj_internal_node.h"
#include "nj_leaf_node.h"

using namespace std;

%}

%%
[\(\)\:,;]                                { return yytext[0]; }
[a-zA-Z0-9_]([ a-zA-Z0-9_]*[a-zA-Z0-9_])? { yylval.str = strdup(yytext); return NAME; }
\-?((0(.[0-9]+)?)|(\-?1(.0+)?))           { yylval.num = atof(yytext); return NUMBER; }
.                                         ;
[\n\t]                                    ;

%%
// C code

int yyparse();
NJInternalNode* generatedRoot();

INJTreeNode* parseFile(const char* filename) {
   yyin = fopen(filename, "r");
   int result = yyparse();
   fclose(yyin);

   //INJTreeNode* node = generatedRoot();
   //while (!node->isLeaf) {
   //     cout << (int) node << endl;
   //     node = ((NJInternalNode*)node)->childNodeLeft;
   //}
   return generatedRoot();
}


