#ifndef __DEFINES_GPU_CUH__
#define __DEFINES_GPU_CUH__


/*******************************************************************************
 * BLOCK_SHAPE defines the width and the height of the one block of threads.   *
 * Each thread corresponds to one pair of sequences and calculates one         *
 * one alignment. It's a good practice to have it multiple of 8. But the best  *
 * results should give 16.                                                     *
 *******************************************************************************/

#define ALIGNMENT_MATCH_BLOCK_SHAPE    16

/*******************************************************************************
 * BLOCK_SIZE defines the count of the threads runs in the multiprocessor in   *
 * the one block. We will threat it as a square and so it should have a value: *
 * BLOCK_SIZE = BLOCK_SHAPE^2                                                  *
 *******************************************************************************/

#define ALIGNMENT_MATCH_BLOCK_SIZE     (ALIGNMENT_MATCH_BLOCK_SHAPE*ALIGNMENT_MATCH_BLOCK_SHAPE)

/*******************************************************************************
 * Y_STEPS defines the number of steps within the sequence Y which will be     *
 * computed in one iteration without an access to the global memory.           *
 * Maximum Y_STEPS value is 12 (as long as size of the shared memory size is   *
 * 16KB per multiprocessor - see CUDA documentation).                          *
 *                                                                             *
 *                             !!!! WARNING !!!!                               *
 *    In contrast to the ALIGNMENT_SCORE_Y_STEPS the ALIGNMENT_MATCH_Y_STEPS   *
 *            CANNOT be modify without changes in the implementation!          *
 *******************************************************************************/

#define ALIGNMENT_MATCH_Y_STEPS         8



/*******************************************************************************
 * The RESHAPE_MEMORY_BLOCK_SIZE refere to the width and height of the shared  *
 * memory in one half-warp which should be the same value as thread count in   *
 * kernel invocation. This value shouldn't be modified.                        *
 *******************************************************************************/

#define ALIGNMENT_MATCH_BLOCK_X_SIZE   16



#endif
