#ifndef _DISTANCE_MATRIX_H_
#define _DISTANCE_MATRIX_H_ 1

#include <cuda_runtime.h>
#include "sequences.h"

using namespace Data;

class DistanceMatrix 
{
public:
    DistanceMatrix(Sequences* seq);
    ~DistanceMatrix();

    void initDistanceMatrixWindow(int winX, int winY, int winSize, short2* identityMatrix);
    void copyDistanceMatrix(DistanceMatrix* sourceDM);
    double getElement(int x, int y);
    void setElement(int x, int y, double value);
    void saveToFile(char* filename);
    void saveToPhylipFile(char* filename);
    int sequenceNumber;
private:
    double* distanceMatrix; //square matrix, but only values below diagonal are valid here
    Sequences* seq;
};
#endif
