#ifndef _EXCEPTIONS_H_
#define	_EXCEPTIONS_H_ 1

#include <stdio.h>
#include <string.h>
#include <iostream>


namespace Exceptions
{

    using namespace std;
    
    class Exception
    {
    public:
        virtual char* getMessage() = 0;
    };

    class FileNotFoundException : public Exception
    {
    private:
        char* message;
    public:
        FileNotFoundException(const char* filename);
        ~FileNotFoundException();
        virtual char* getMessage();
    };

    class IndexOutOfRangeException : public Exception
    {
    private:
        char* message;
    public:
        IndexOutOfRangeException(const char* msg);
        ~IndexOutOfRangeException();
        virtual char* getMessage();
    };

    class ConversionException : public Exception
    {
    private:
        char* message;
    public:
        ConversionException(const char* msg);
        ~ConversionException();
        virtual char* getMessage();
    };

    class IncorrectInputData : public Exception
    {
    private:
        char* message;
    public:
        IncorrectInputData(const char* msg);
        ~IncorrectInputData();
        virtual char* getMessage();
    };

    class ParamDoesntExistException
    {
    private:
        string message;
    public:
        ParamDoesntExistException(string msg);
        virtual string getMessage();
    };

}

#endif

