#ifndef _NJ_INTERNAL_NODE_H_
#define _NJ_INTERNAL_NODE_H_

#include "i_nj_tree_node.h"

class NJInternalNode : public INJTreeNode
{
public:

    virtual void ToString(char*& memoryForString, int& offset, int& totalElementsCount);

    virtual int maxHeight();

    virtual INJTreeNodeList* collectNodes(int height, INJTreeNodeList* list = NULL);

    virtual INJSequencesNoList* collectSequenceNumbers(INJSequencesNoList* list = NULL);

    //left child of the internal node (never NULL)
    INJTreeNode* childNodeLeft;

    //right child of the internal node (never NULL)
    INJTreeNode* childNodeRight;

    static void setChildNodeLeft(NJInternalNode* This, INJTreeNode* node);
    static void setChildNodeRight(NJInternalNode* This, INJTreeNode* node);
    static void determineLeavesNumber(NJInternalNode* This);
    static NJInternalNode* createNJInternalNode();
};

#endif /* _NJ_INTERNAL_NODE_H_ */
