#include <string.h>
#include <stdlib.h>

#include "nj_leaf_node.h"
#include "exceptions.h"

using namespace Exceptions;


NJLeafNode* NJLeafNode::createNJLeafNode()
{
    NJLeafNode* result = new NJLeafNode();
    result->numOfLeaves = 1;
    return result;
}

void NJLeafNode::setSequenceName(NJLeafNode* This, string s)
{
    This->sequenceName = strdup(s.c_str());
    //printf("%s\n", This->sequenceName);
}

void NJLeafNode::ToString(char*& memoryForString, int& offset, int& totalElementsCount)
{
    // format:
    //
    // sequence127:0.14132


    this->resizeMemoryIfNeeded(memoryForString, offset, totalElementsCount);

    char* actual = this->sequenceName;

    while(*actual)
    {
        memoryForString[offset] = *actual;
        actual++;
        offset++;
    }

    sprintf(&(memoryForString[offset]), ":%.5f", value);
    offset+=8;
    
}

int NJLeafNode::maxHeight()
{
    return 0;
}

INJTreeNodeList* NJLeafNode::collectNodes(int height, INJTreeNodeList* list)
{
    //throw new IndexOutOfRangeException("Error. The node which has been reached is a leaf node - there is nothing to align here.");
    return list;
}

INJSequencesNoList* NJLeafNode::collectSequenceNumbers(INJSequencesNoList* list)
{
    if (list == NULL)
    {
        list = new INJSequencesNoList();
        list->first = NULL;
    }

    INJSequencesNoListElement* newNode = new INJSequencesNoListElement();
    newNode->seqNo = this->seqNo;
    newNode->next = list->first;
    list->first = newNode;
    list->count++;
    return list;
}
