#ifndef _NJ_LEAF_NODE_H_
#define _NJ_LEAF_NODE_H_

#include "i_nj_tree_node.h"
#include <stdio.h>
#include <string>

using namespace std;

class NJLeafNode : public INJTreeNode
{
public:
    virtual void ToString(char*& memoryForString, int& offset, int& totalElementsCount);

    virtual int maxHeight();

    virtual INJTreeNodeList* collectNodes(int height, INJTreeNodeList* list = NULL);

    virtual INJSequencesNoList* collectSequenceNumbers(INJSequencesNoList* list = NULL);

    // name of seqence
    char* sequenceName;
    int seqNo; // number of a sequence corresponding to its position after reading from a file and sorting


    static void setSequenceName(NJLeafNode* This, string s);
    static NJLeafNode* createNJLeafNode();
};

#endif /* _NJ_LEAF_NODE_H_ */
