#include "partial_primary_library.h"
#include <stddef.h>
#include "exceptions.h"

using namespace Exceptions;

PartialPrimaryLibrary::PartialPrimaryLibrary()
{
    ppl =  NULL;
    starts =  NULL;
}

PartialPrimaryLibrary::~PartialPrimaryLibrary()
{
    if(ppl != NULL)
        delete[] ppl;
    if(starts != NULL)
        delete[] starts;
}

void PartialPrimaryLibrary::allocateStarts(unsigned int windowSize)
{
    starts = new unsigned int[windowSize * windowSize + 1];//+1 because we want to know how long the last alignment is
    this->windowSize = windowSize;
}

void PartialPrimaryLibrary::allocatePPL(unsigned int numberOfElements)
{
    try
    {
        ppl = new unsigned int[numberOfElements];
        this->numberOfElements = numberOfElements;
    }
    catch(...)
    {
        printf("Allocation of %.0fMB memory failed.\n", ((double)numberOfElements*4)/(1024.0*1024.0));
        throw new IndexOutOfRangeException("Not enough memory for partial primary library! Terminating.");
    }
}
