#ifndef __PARTIAL_PRIMARY_LIBRARY_H__
#define __PARTIAL_PRIMARY_LIBRARY_H__ 1

/*
 * Here all data is stored before it goes to primary library.
 * Each window of pairwise sequence alignment has its own
 * partial primary library.
 * After all windows of pairwise sequence alignment are computed
 * primary library is constructed from all partial primary libraries.
 *
 */

class PartialPrimaryLibrary
{
public:
    PartialPrimaryLibrary();
    ~PartialPrimaryLibrary();

    unsigned int* ppl;
    unsigned int* starts;
    unsigned int windowSize; //windowSize * windowSize - number of alignments
    unsigned int numberOfElements;

    void allocateStarts(unsigned int windowSize);
    void allocatePPL(unsigned int numberOfElements);
};



#endif
