#ifndef __PRIMARY_LIBRARY_H__
#define __PRIMARY_LIBRARY_H__ 1

#include "i_library.h"
#include "partial_primary_library.h"
#include "sequences.h"
#include "exceptions.h"

using Data::Sequences;
using namespace Exceptions;


class PrimaryLibrary : public ILibrary
{
public:
    PrimaryLibrary();
    ~PrimaryLibrary();

    //ppl isn't square array, it is an array of pointers
    void createPL(PartialPrimaryLibrary** ppl, int NumOfWindowsInOneRow, unsigned int NumOfSequences);

    virtual int getResiduePosIn1Seq(int seq1No, int seq2No, int element);
    virtual int getResiduePosIn2Seq(int seq1No, int seq2No, int element);
    virtual int getWeight(int seq1No, int seq2No, int element);
    virtual void saveLibraryToFile(const char* filename, void* extLib, Sequences* seqs, int K);


    /*
     * pl - primary library array:
     *
     * 12 bits - position of residue in first sequence
     * 12 bits - position of residue in second sequence
     *  8 bits - weight (max weight value is 200)
     *
     */

    unsigned int* pl;
    unsigned int* starts;
    unsigned int seqCount;
    unsigned int totalNumOfElements; // total number of elements in Primary Library
    

};


#endif
